/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEntityToolSwapUpgrade;

public class EntityToolSwapMessage {
    private final int entityId;

    public EntityToolSwapMessage(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(EntityToolSwapMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.entityId);
    }

    public static EntityToolSwapMessage decode(PacketBuffer packetBuffer) {
        return new EntityToolSwapMessage(packetBuffer.readInt());
    }

    static void onMessage(EntityToolSwapMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> EntityToolSwapMessage.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(EntityToolSwapMessage msg, @Nullable ServerPlayerEntity sender) {
        if (sender == null) {
            return;
        }
        World world = sender.field_70170_p;
        Entity entity = world.func_73045_a(msg.entityId);
        if (entity == null) {
            return;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        AtomicBoolean anyUpgradeCanInteract = new AtomicBoolean(false);
        SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().runOnBackpacks((PlayerEntity)sender, (backpack, inventoryName, slot) -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(backpackWrapper -> {
            backpackWrapper.getUpgradeHandler().getWrappersThatImplement(IEntityToolSwapUpgrade.class).forEach(upgrade -> {
                if (!upgrade.canProcessEntityInteract() || result.get()) {
                    return;
                }
                anyUpgradeCanInteract.set(true);
                result.set(upgrade.onEntityInteract(world, entity, (PlayerEntity)sender));
            });
            return result.get();
        }).orElse(false));
        if (!anyUpgradeCanInteract.get()) {
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("gui.sophisticatedbackpacks.status.no_tool_swap_upgrade_present"), true);
            return;
        }
        if (!result.get()) {
            sender.func_146105_b((ITextComponent)new TranslationTextComponent("gui.sophisticatedbackpacks.status.no_tool_found_for_entity"), true);
        }
    }
}

